// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/platform_verification.mojom
//

package org.chromium.mojom.media.interfaces;

class PlatformVerification_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<PlatformVerification, PlatformVerification.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<PlatformVerification, PlatformVerification.Proxy>() {
    
        public String getName() {
            return "media::interfaces::PlatformVerification";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, PlatformVerification impl) {
            return new Stub(core, impl);
        }
    
        public PlatformVerification[] buildArray(int size) {
          return new PlatformVerification[size];
        }
    };

    private static final int CHALLENGE_PLATFORM_ORDINAL = 0;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements PlatformVerification.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void challengePlatform(String serviceId, String challenge, ChallengePlatformResponse callback) {
            PlatformVerificationChallengePlatformParams _message = new PlatformVerificationChallengePlatformParams();
            _message.serviceId = serviceId;
            _message.challenge = challenge;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CHALLENGE_PLATFORM_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PlatformVerificationChallengePlatformResponseParamsForwardToCallback(callback));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<PlatformVerification> {

        Stub(org.chromium.mojo.system.Core core, PlatformVerification impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                PlatformVerification_Internal.MANAGER, messageWithHeader);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), PlatformVerification_Internal.MANAGER, messageWithHeader, receiver);
                    case CHALLENGE_PLATFORM_ORDINAL: {
                        PlatformVerificationChallengePlatformParams data =
                                PlatformVerificationChallengePlatformParams.deserialize(messageWithHeader.getPayload());
                        getImpl().challengePlatform(data.serviceId, data.challenge, new PlatformVerificationChallengePlatformResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class PlatformVerificationChallengePlatformParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String serviceId;
        public String challenge;
    
        private PlatformVerificationChallengePlatformParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PlatformVerificationChallengePlatformParams() {
            this(0);
        }
    
        public static PlatformVerificationChallengePlatformParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PlatformVerificationChallengePlatformParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PlatformVerificationChallengePlatformParams result = new PlatformVerificationChallengePlatformParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.serviceId = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.challenge = decoder0.readString(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(serviceId, 8, false);
            encoder0.encode(challenge, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PlatformVerificationChallengePlatformParams other = (PlatformVerificationChallengePlatformParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.serviceId, other.serviceId))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.challenge, other.challenge))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(serviceId);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(challenge);
            return result;
        }
    }

    static final class PlatformVerificationChallengePlatformResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 40;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(40, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public boolean success;
        public String signedData;
        public String signedDataSignature;
        public String platformKeyCertificate;
    
        private PlatformVerificationChallengePlatformResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PlatformVerificationChallengePlatformResponseParams() {
            this(0);
        }
    
        public static PlatformVerificationChallengePlatformResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PlatformVerificationChallengePlatformResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PlatformVerificationChallengePlatformResponseParams result = new PlatformVerificationChallengePlatformResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.success = decoder0.readBoolean(8, 0);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.signedData = decoder0.readString(16, true);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.signedDataSignature = decoder0.readString(24, true);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.platformKeyCertificate = decoder0.readString(32, true);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(success, 8, 0);
            encoder0.encode(signedData, 16, true);
            encoder0.encode(signedDataSignature, 24, true);
            encoder0.encode(platformKeyCertificate, 32, true);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PlatformVerificationChallengePlatformResponseParams other = (PlatformVerificationChallengePlatformResponseParams) object;
            if (this.success != other.success)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.signedData, other.signedData))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.signedDataSignature, other.signedDataSignature))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.platformKeyCertificate, other.platformKeyCertificate))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(success);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(signedData);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(signedDataSignature);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(platformKeyCertificate);
            return result;
        }
    }

    static class PlatformVerificationChallengePlatformResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final PlatformVerification.ChallengePlatformResponse mCallback;

        PlatformVerificationChallengePlatformResponseParamsForwardToCallback(PlatformVerification.ChallengePlatformResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CHALLENGE_PLATFORM_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                PlatformVerificationChallengePlatformResponseParams response = PlatformVerificationChallengePlatformResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.success, response.signedData, response.signedDataSignature, response.platformKeyCertificate);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PlatformVerificationChallengePlatformResponseParamsProxyToResponder implements PlatformVerification.ChallengePlatformResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PlatformVerificationChallengePlatformResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean success, String signedData, String signedDataSignature, String platformKeyCertificate) {
            PlatformVerificationChallengePlatformResponseParams _response = new PlatformVerificationChallengePlatformResponseParams();
            _response.success = success;
            _response.signedData = signedData;
            _response.signedDataSignature = signedDataSignature;
            _response.platformKeyCertificate = platformKeyCertificate;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CHALLENGE_PLATFORM_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

}

